% ---------------------------------------------------------------------
% Este script hace la Figura con el ejemplo de la estabilidad
% del mtodo de Euler en el problema de la desintegracin radiactiva
% ---------------------------------------------------------------------

%Definiciones y parmetros

k=1;
fun = @(t,y) -k*y;
y0=100;
t0=0;
tf=15;

%Ejemplo con paso inestable

Nh=7;
[tbad,ybad]=feuler(fun,t0,tf,y0,Nh);

%Ejemplo con paso estable

Nh=30;
[tOK,yOK]=feuler(fun,t0,tf,y0,Nh);

%Solucin exacta

tp=0:0.1:tf;
yp=y0*exp(-k*tp);

%Hacemos la figura

plot(tp,yp,tbad,ybad,'-or',tOK,yOK,'+k');
xlabel('t');
ylabel('N');
title('Estabilidad del mtodo de Euler');
legend('Sol. exacta','Euler (h=15/7)','Euler (h=0.5)','Location','NorthWest');
text(7,250,'k=1');
